<?php

namespace VM\FinancialStatementsBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieProdukcjiDS;
use VM\FinancialStatementsBundle\Services\DataStructure\SprawozdaniaDS;
use VM\FinancialStatementsBundle\Services\FinansowanieInwestycji;
use VM\FinancialStatementsBundle\Services\FinansowanieInwestycjiPodsumowanie;
use VM\FinancialStatementsBundle\Services\FinansowanieProdukcji;
use VM\FinancialStatementsBundle\Services\Gra;
use VM\FinancialStatementsBundle\Services\Lokata;
use VM\FinancialStatementsBundle\Services\LokatyPodsumowanie;
use VM\FinancialStatementsBundle\Services\Sprawozdania;
use VM\FinancialStatementsBundle\Services\SprawozdawczoscUproszczona;

class DefaultController extends Controller
{
    public function indexAction()
    {
        $this->renderAbsolute();
        return $this->render('VMFinancialStatementsBundle:Default:index.html.twig', array());
    }

    protected function renderAbsolute()
    {
        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->naklady = 2000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1000;
        $FinansowanieInwestycjiDS->kapitalObcy = 1000;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 5;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieProdukcjiDS = new FinansowanieProdukcjiDS();
        $FinansowanieProdukcjiDS->wielkoscRynku = 200000000;
        $FinansowanieProdukcjiDS->udzialWRynku = 0.03;
        $FinansowanieProdukcjiDS->cenaProduktu = 24.5;
        $FinansowanieProdukcjiDS->nakladyNaPiR = 0.07;
        $FinansowanieProdukcjiDS->nakladyNaInnowacje = 0.05;
        $FinansowanieProdukcjiDS->mozliwosciProdukcyjne = 1300000;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
        $FinansowanieProdukcjiDS->kosztyStale = array(
            'osobowe'=>array('q'=>10, 'kj'=>61200),
            'materialowe'=>array('q'=>1200, 'kj'=>6),
            'energia'=>array('q'=>36000, 'kj'=>0.6),
            'ubezpieczenia'=>array('q'=>1, 'kj'=>10000),
            'telekomunikacja'=>array('q'=>1, 'kj'=>72000),
            'podatkiLokalne'=>array('q'=>1, 'kj'=>30000),
            'oplatyBankowe'=>array('q'=>1, 'kj'=>1200),
        );
        $FinansowanieProdukcjiDS->kosztyZmienne = array(
            'osobowe'=>array('kjz'=>0.2, 'cenaJednostki'=>29.6511627907),
            'materialowe'=>array('kjz'=>0.5, 'cenaJednostki'=>3),
            'energia'=>array('kjz'=>2, 'cenaJednostki'=>0.6),
            'woda'=>array('kjz'=>0.15, 'cenaJednostki'=>7),
            'kosztyLogistyki'=>array('kjz'=>1, 'cenaJednostki'=>0.3),
        );

        $Gra = new Gra(1);

        $Gra->addFinansowanieInwestycji($FinansowanieInwestycjiDS);
        $Gra->addFinansowanieInwestycji($FinansowanieInwestycjiDS);

        $Gra->addPrzychodyFinansowe(300);
        $Gra->addKredytObrotowy(1000000);
        $Gra->addOdsetkiKredytuObrotowego(50000);

        $Gra->addFinansowanieProdukcji($FinansowanieProdukcjiDS);
//        $przeliczone = $Gra->getAll();

        $przeliczone = $Gra->evalAndGetNextIteration();

//        $Gra->addFinansowanieInwestycji($FinansowanieInwestycjiDS);
//        $Gra->addFinansowanieInwestycji($FinansowanieInwestycjiDS);

        $Gra->addPrzychodyFinansowe(300);
        $Gra->addKredytObrotowy(1000000);
        $Gra->addOdsetkiKredytuObrotowego(50000);

//        $Gra->addFinansowanieProdukcji($FinansowanieProdukcjiDS);

        $przeliczone = $Gra->evalAndGetNextIteration();

        $Gra->addPrzychodyFinansowe(300);
        $Gra->addKredytObrotowy(1000000);
        $Gra->addOdsetkiKredytuObrotowego(50000);

//        $Gra->addFinansowanieProdukcji($FinansowanieProdukcjiDS);

        $przeliczone = $Gra->evalAndGetNextIteration();

//        $FinansowanieProdukcjiDS->cenaProduktu = 23.5;
//        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
//        $Gra->addPrzychodyFinansowe(300);
//        $Gra->addKredytObrotowy(1000000);
//        $Gra->addOdsetkiKredytuObrotowego(50000);
//
//        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);
//
//        $FinansowanieProdukcjiDS->cenaProduktu = 24;
//        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
//
//        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);
//
//        $FinansowanieProdukcjiDS->cenaProduktu = 24;
//        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
//
//        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);


        echo "<pre>";
        echo print_r($przeliczone);
        echo "<br><br><br>";
        echo "</pre>";
    }

    protected function renderSprawozdawczoscUproszczona()
    {
        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->rokPoczatkowy = 2014;
        $FinansowanieInwestycjiDS->liczbaLat = 8;
        $FinansowanieInwestycjiDS->naklady = 2000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1000;
        $FinansowanieInwestycjiDS->kapitalObcy = 1000;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 5;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieInwestycjiPierwsza = FinansowanieInwestycji::create($FinansowanieInwestycjiDS);

        $PodsumowanieFinansowaniaInwestycji = new FinansowanieInwestycjiPodsumowanie();
        $PodsumowanieFinansowaniaInwestycji->addFinansowanieInwestycji($FinansowanieInwestycjiPierwsza);

        $FinansowanieProdukcjiDS = new FinansowanieProdukcjiDS();
        $FinansowanieProdukcjiDS->wielkoscRynku = 200000000;
        $FinansowanieProdukcjiDS->udzialWRynku = 0.03;
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->nakladyNaPiR = 400000;
        $FinansowanieProdukcjiDS->nakladyNaInnowacje = 200000;
        $FinansowanieProdukcjiDS->iloscRownowagiElastyczny = 8333333.33;
        $FinansowanieProdukcjiDS->rokPoczatkowy = 2014;
        $FinansowanieProdukcjiDS->mozliwosciProdukcyjne = 300000;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
        $FinansowanieProdukcjiDS->kosztyStale = array(
            'osobowe'=>array('q'=>10, 'kj'=>61200),
            'materialowe'=>array('q'=>1200, 'kj'=>6),
            'energia'=>array('q'=>36000, 'kj'=>0.6),
            'ubezpieczenia'=>array('q'=>1, 'kj'=>10000),
            'telekomunikacja'=>array('q'=>1, 'kj'=>72000),
            'podatkiLokalne'=>array('q'=>1, 'kj'=>30000),
            'oplatyBankowe'=>array('q'=>1, 'kj'=>1200),
        );
        $FinansowanieProdukcjiDS->kosztyZmienne = array(
            'osobowe'=>array('kjz'=>0.2, 'cenaJednostki'=>29.6511627907),
            'materialowe'=>array('kjz'=>0.5, 'cenaJednostki'=>3),
            'energia'=>array('kjz'=>2, 'cenaJednostki'=>0.6),
            'woda'=>array('kjz'=>0.15, 'cenaJednostki'=>7),
            'kosztyLogistyki'=>array('kjz'=>1, 'cenaJednostki'=>0.3),
        );

        $FinansowanieProdukcji = FinansowanieProdukcji::create($FinansowanieProdukcjiDS);

        $LokatyPodsumowanie = new LokatyPodsumowanie();

        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);

        $SprawozdaniaDS = new SprawozdaniaDS();
        $SprawozdaniaDS->rokPoczatkowy = 2014;
        $SprawozdaniaDS->ileIteracji = 7;
        $SprawozdaniaDS->kapitalPodstawowy = 2000000;
        $SprawozdaniaDS->LokatyPodsumowanie = $LokatyPodsumowanie;
        $SprawozdaniaDS->FinansowanieProdukcji = $FinansowanieProdukcji;
        $SprawozdaniaDS->PodsumowanieFinansowaniaInwestycji = $PodsumowanieFinansowaniaInwestycji;

        $Sprawozdania = Sprawozdania::create($SprawozdaniaDS);

        $Sprawozdawczosc = new SprawozdawczoscUproszczona($Sprawozdania);

        echo "<pre>";
        echo print_r($Sprawozdawczosc->getSprawozdawczoscUproszczona())."<br><br>";
        echo "<br><br><br>";
//        echo "Funkcja popytu<br>";
//        echo print_r($FinansowanieProdukcji->getFunkcjaPopytu());
//        echo "<br><br><br>";
        echo "</pre>";
    }

    protected function renderSprawozdania()
    {
        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->rokPoczatkowy = 2014;
        $FinansowanieInwestycjiDS->liczbaLat = 8;
        $FinansowanieInwestycjiDS->naklady = 2000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1000;
        $FinansowanieInwestycjiDS->kapitalObcy = 1000;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 5;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieInwestycjiPierwsza = FinansowanieInwestycji::create($FinansowanieInwestycjiDS);

//        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
//        $FinansowanieInwestycjiDS->rokPoczatkowy = 2014;
//        $FinansowanieInwestycjiDS->liczbaLat = 8;
//        $FinansowanieInwestycjiDS->naklady = 3000;
//        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
//        $FinansowanieInwestycjiDS->kapitalWlasny = 1500;
//        $FinansowanieInwestycjiDS->kapitalObcy = 1500;
//        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
//        $FinansowanieInwestycjiDS->czyKredyt = true;
//        $FinansowanieInwestycjiDS->czyLeasing = false;
//        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
//        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
//        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 3;
//        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;
//
//        $FinansowanieInwestycjiDruga = FinansowanieInwestycji::create($FinansowanieInwestycjiDS);

        $PodsumowanieFinansowaniaInwestycji = new FinansowanieInwestycjiPodsumowanie();
        $PodsumowanieFinansowaniaInwestycji->addFinansowanieInwestycji($FinansowanieInwestycjiPierwsza);
//        $PodsumowanieFinansowaniaInwestycji->addFinansowanieInwestycji($FinansowanieInwestycjiDruga);

        $FinansowanieProdukcjiDS = new FinansowanieProdukcjiDS();
        $FinansowanieProdukcjiDS->wielkoscRynku = 200000000;
        $FinansowanieProdukcjiDS->udzialWRynku = 0.03;
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->nakladyNaPiR = 0.07;
        $FinansowanieProdukcjiDS->nakladyNaInnowacje = 0.05;
        $FinansowanieProdukcjiDS->iloscRownowagiElastyczny = 8333333.33;
        $FinansowanieProdukcjiDS->rokPoczatkowy = 2014;
        $FinansowanieProdukcjiDS->mozliwosciProdukcyjne = 300000;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 270000;
        $FinansowanieProdukcjiDS->kosztyStale = array(
            'osobowe'=>array('q'=>10, 'kj'=>61200),
            'materialowe'=>array('q'=>1200, 'kj'=>6),
            'energia'=>array('q'=>36000, 'kj'=>0.6),
            'ubezpieczenia'=>array('q'=>1, 'kj'=>10000),
            'telekomunikacja'=>array('q'=>1, 'kj'=>72000),
            'podatkiLokalne'=>array('q'=>1, 'kj'=>30000),
            'oplatyBankowe'=>array('q'=>1, 'kj'=>1200),
        );
        $FinansowanieProdukcjiDS->kosztyZmienne = array(
            'osobowe'=>array('kjz'=>0.2, 'cenaJednostki'=>29.6511627907),
            'materialowe'=>array('kjz'=>0.5, 'cenaJednostki'=>3),
            'energia'=>array('kjz'=>2, 'cenaJednostki'=>0.6),
            'woda'=>array('kjz'=>0.15, 'cenaJednostki'=>7),
            'kosztyLogistyki'=>array('kjz'=>1, 'cenaJednostki'=>0.3),
        );

        $FinansowanieProdukcji = FinansowanieProdukcji::create($FinansowanieProdukcjiDS);

        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 280000;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 240000;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);

        $SprawozdaniaDS = new SprawozdaniaDS();
        $SprawozdaniaDS->rokPoczatkowy = 2014;
        $SprawozdaniaDS->ileIteracji = 6;
        $SprawozdaniaDS->kapitalPodstawowy = 2000000;
        $SprawozdaniaDS->FinansowanieProdukcji = $FinansowanieProdukcji;
        $SprawozdaniaDS->PodsumowanieFinansowaniaInwestycji = $PodsumowanieFinansowaniaInwestycji;

        $SprawozdaniaDS->przychodyFinansowe = array_fill($SprawozdaniaDS->rokPoczatkowy+1, $SprawozdaniaDS->ileIteracji-1, 300);
        $SprawozdaniaDS->przychodyFinansowe[$SprawozdaniaDS->rokPoczatkowy] = 0;

        $SprawozdaniaDS->kredytObrotowy = array_fill($SprawozdaniaDS->rokPoczatkowy, $SprawozdaniaDS->ileIteracji, 500000);
//        $SprawozdaniaDS->kredytObrotowy[$SprawozdaniaDS->rokPoczatkowy] = 0;

        $SprawozdaniaDS->odsetkiKredytuObrotowego = array_fill($SprawozdaniaDS->rokPoczatkowy+1, $SprawozdaniaDS->ileIteracji-1, 25000);
        $SprawozdaniaDS->odsetkiKredytuObrotowego[$SprawozdaniaDS->rokPoczatkowy] = 0;

        $Sprawozdania = Sprawozdania::create($SprawozdaniaDS);

        echo "<pre>";
        echo print_r($Sprawozdania->getResultsOf('Aktywa')->razem)."<br><br>";
        echo print_r($Sprawozdania->getResultsOf('Pasywa')->razem)."<br><br>";
        echo print_r($Sprawozdania->getResultsOf('Aktywa'))."<br><br>";
        echo print_r($Sprawozdania->getResultsOf('Pasywa'))."<br><br>";
        echo print_r($Sprawozdania->getResultsOf('RachunekZyskowIStrat'))."<br><br>";
        echo print_r($Sprawozdania->getResultsOf('RachunekPrzeplywowPienieznych'))."<br><br>";
        echo print_r($Sprawozdania->getResultsOf('WskaznikiFinansowe'))."<br><br>";
        echo "<br><br><br>";
//        echo "Funkcja popytu<br>";
//        echo print_r($FinansowanieProdukcji->getFunkcjaPopytu());
//        echo "<br><br><br>";
        echo "</pre>";
    }

    protected function renderPodsumowanieWszystkichInwestycji()
    {
        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->rokPoczatkowy = 2014;
        $FinansowanieInwestycjiDS->liczbaLat = 8;
        $FinansowanieInwestycjiDS->naklady = 2000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1000;
        $FinansowanieInwestycjiDS->kapitalObcy = 1000;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 5;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieInwestycjiPierwsza = FinansowanieInwestycji::create($FinansowanieInwestycjiDS);

        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->rokPoczatkowy = 2014;
        $FinansowanieInwestycjiDS->liczbaLat = 8;
        $FinansowanieInwestycjiDS->naklady = 3000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1500;
        $FinansowanieInwestycjiDS->kapitalObcy = 1500;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 3;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieInwestycjiDruga = FinansowanieInwestycji::create($FinansowanieInwestycjiDS);

        $PodsumowanieFinansowaniaInwestycji = new FinansowanieInwestycjiPodsumowanie();
        $PodsumowanieFinansowaniaInwestycji->addFinansowanieInwestycji($FinansowanieInwestycjiPierwsza);
        $PodsumowanieFinansowaniaInwestycji->addFinansowanieInwestycji($FinansowanieInwestycjiDruga);

//        echo "<pre>Pierwsza inwestycja:<br>";
//        echo print_r($FinansowanieInwestycjiPierwsza->getResultsOf('Amortyzacja'));
//        echo "</pre>";
//        echo "<pre><br><br>";
//        echo print_r($FinansowanieInwestycjiPierwsza->getResultsOf('Podsumowanie'));
//        echo "</pre>";
//
//        echo "<pre><br><br><br>Druga inwestycja:<br>";
//        echo print_r($FinansowanieInwestycjiDruga->getResultsOf('Amortyzacja'));
//        echo "</pre>";
//        echo "<pre><br><br>";
//        echo print_r($FinansowanieInwestycjiDruga->getResultsOf('Podsumowanie'));
//        echo "</pre>";

        echo "<pre><br><br><br>Podsumowanie:<br>";
        echo print_r($PodsumowanieFinansowaniaInwestycji->getPodsumowanieWszystkichInwestycji());
        echo "</pre>";
    }

    protected function renderFinansowanieProdukcji()
    {
        $FinansowanieProdukcjiDS = new FinansowanieProdukcjiDS();
        $FinansowanieProdukcjiDS->wielkoscRynku = 200000000;
        $FinansowanieProdukcjiDS->udzialWRynku = 0.03;
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->nakladyNaPiR = 400000;
        $FinansowanieProdukcjiDS->nakladyNaInnowacje = 300000;
        $FinansowanieProdukcjiDS->iloscRownowagiElastyczny = 8333333.33;
        $FinansowanieProdukcjiDS->rokPoczatkowy = 2014;
        $FinansowanieProdukcjiDS->mozliwosciProdukcyjne = 300000;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
        $FinansowanieProdukcjiDS->kosztyStale = array(
            'osobowe'=>array('q'=>10, 'kj'=>61200),
            'materialowe'=>array('q'=>1200, 'kj'=>6),
            'energia'=>array('q'=>36000, 'kj'=>0.6),
            'ubezpieczenia'=>array('q'=>1, 'kj'=>10000),
            'telekomunikacja'=>array('q'=>1, 'kj'=>72000),
            'podatkiLokalne'=>array('q'=>1, 'kj'=>30000),
            'oplatyBankowe'=>array('q'=>1, 'kj'=>1200),
        );
        $FinansowanieProdukcjiDS->kosztyZmienne = array(
            'osobowe'=>array('kjz'=>0.2, 'cenaJednostki'=>29.6511627907),
            'materialowe'=>array('kjz'=>0.5, 'cenaJednostki'=>3),
            'energia'=>array('kjz'=>2, 'cenaJednostki'=>0.6),
            'woda'=>array('kjz'=>0.15, 'cenaJednostki'=>7),
            'kosztyLogistyki'=>array('kjz'=>1, 'cenaJednostki'=>0.3),
        );

        $FinansowanieProdukcji = FinansowanieProdukcji::create($FinansowanieProdukcjiDS);

        echo "<pre>";
        echo "Wariant proporcjonalny Iteracja 1<br>";
        echo print_r($FinansowanieProdukcji->getWariantProporcjonalnyByYear(2014));
        echo "<br><br><br>";
//        echo "Funkcja popytu<br>";
//        echo print_r($FinansowanieProdukcji->getFunkcjaPopytu());
//        echo "<br><br><br>";
        echo "</pre>";

        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 210000;
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);


        echo "<pre>";
        echo "Wariant proporcjonalny Iteracja 2<br>";
        echo print_r($FinansowanieProdukcji->getWariantProporcjonalnyByYear(2015));
        echo "<br><br><br>";
        echo "</pre>";
        $FinansowanieProdukcji->nextIteration($FinansowanieProdukcjiDS);


        echo "<pre>";
        echo "Wariant proporcjonalny Iteracja 3<br>";
        echo print_r($FinansowanieProdukcji->getWariantProporcjonalnyByYear(2016));
        echo "<br><br><br>";
        echo "</pre>";
    }

    protected function renderFinansowanieInwestycji()
    {
        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->rokPoczatkowy = 2014;
        $FinansowanieInwestycjiDS->liczbaLat = 8;
        $FinansowanieInwestycjiDS->naklady = 2000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1000;
        $FinansowanieInwestycjiDS->kapitalObcy = 1000;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 5;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieInwestycji = FinansowanieInwestycji::create($FinansowanieInwestycjiDS);

        echo "<pre>";
        echo "Amortyzacja<br>";
        echo print_r($FinansowanieInwestycji->getResultsOf('Amortyzacja'));
        echo "<br><br><br>";
        echo "Finansowanie<br>";
        echo print_r($FinansowanieInwestycji->getResultsOf('Finansowanie'));
        echo "<br><br><br>";
        echo "Leasing<br>";
        echo print_r($FinansowanieInwestycji->getResultsOf('Leasing'));
        echo "<br><br><br>";
        echo "Kredyt<br>";
        echo print_r($FinansowanieInwestycji->getResultsOf('Kredyt'));
        echo "<br><br><br>";
        echo "Podsumowanie<br>";
        echo print_r($FinansowanieInwestycji->getResultsOf('Podsumowanie'));
        echo "<br><br><br>";
        echo "</pre>";
    }
}
